// load the things we need
var express = require('express');
var cookieParser = require('cookie-parser');
var session = require('express-session');
var app = express();
var bodyParser = require('body-parser');
var axios = require('axios');
let multer = require('multer');
let upload = multer({ storage: multer.memoryStorage() });
// set the view engine to ejs
app.set('view engine', 'ejs');
app.use(express.static("views"));
var formidable = require('formidable');
// use res.render to load up an ejs view file


app.use(cookieParser());
app.use(session({ secret: "FreshSecret" }));

// parse html forms
app.use(bodyParser.urlencoded({ extended: false }));

app.use(function (req, res, next) {
    var err = req.session.error;
    delete req.session.error;
    res.locals.userid = req.session.userid;
    res.locals.error = err;
    res.locals.cid = '';
    res.locals.pagetitle = '';
    res.locals.scid = '';
    next();
});

//Website Pages
// login page 
app.get('/', function (req, res) {

    var data = '';
    console.log("hello");
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/home',
        headers: {},
        data: data
    };
    axios(config)
        .then(function (response) {
            res.render('site/index', {
                data: response.data
            });
        })
        .catch(function (error) {
            res.render('site/index', {
                data: []
            });
        });

});

// Test page
app.get('/test', function (req, res) {
    res.render('site/test');
});

// Login page
app.get('/login', function (req, res) {
    res.render('site/login');
});

// Signup page submit
app.post('/register', function (req, res) {

    var { name, email, phone, password, newsletter } = req.body;

    var data = JSON.stringify({
        "name": name,
        "email": email,
        "phone": phone,
        "password": password,
        "newsletter": "1"
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/users',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            var sts = response.status;
            var dat = response.data;
            //console.log(dat.status);
            if (sts == 201) {

                var st = dat.status;
                if (st == 'success') {
                    req.session.error = 'Registered successfully';
                    res.redirect('/login');
                } else {

                    res.locals.error = 'User already exists';
                    res.render('site/login');
                }

            } else {

                res.locals.error = 'Some error occurred';
                res.render('site/login');
            }
        })
        .catch(function (error) {
            console.log(error);
        });

});

// Login page submit
app.post('/login', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/users/' + req.body.email + '/' + req.body.password,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            var sts = response.status;
            var dat = response.data;
            //console.log(dat.status);
            if (sts == 201) {

                var st = dat.status;
                if (st == 'success') {
                    req.session.userid = dat.data[0].id;
                    req.session.error = 'Welcome';
                    res.redirect('/');
                } else {

                    res.locals.error = 'Invalid details';
                    res.render('site/login');
                }

            } else {

                res.locals.error = 'Some error occurred';

                res.render('site/login');
            }
        })
        .catch(function (error) {
            console.log(error);
        });

});


app.get('/logout', function (req, res) {
    // destroy the user's session to log them out
    // will be re-created next request
    req.session.destroy(function () {
        //req.session.error = 'Logged out successfully';
        res.redirect('/');
    });
});

// Products page
app.get('/products/:cid', function (req, res) {

    var { cid } = req.params;

    var str = cid.split('_');
    cid = str[0];
    var id = str[1];

    console.log(cid);

    var data = '';
    var catname = '';
    var meta_keywords = '';
    var meta_description = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/sub-categories/' + cid,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {

            var data2 = '';
            //console.log(response);
            if (id == '0') {
                id = response.data.data[0].id;
            }

            catname = response.data.data[0].cat_name;
            meta_keywords = response.data.data[0].meta_keywords;
            meta_description = response.data.data[0].meta_description;


            var config2 = {
                method: 'get',
                url: 'http://65.1.15.21:5000/api/products/' + id,
                headers: {},
                data: data2
            };

            axios(config2)
                .then(function (response2) {
                    //console.log(response2);
                    res.render('site/products', {
                        data: response.data,
                        data2: response2.data,
                        cid: cid,
                        scid: id,
                        catname: catname,
                        meta_keywords: meta_keywords,
                        meta_description: meta_description
                    });
                })
                .catch(function (error2) {
                    res.render('site/products', {
                        data: [],
                        data2: [],
                        cid: cid,
                        scid: id,
                        catname: catname,
                        meta_keywords: meta_keywords,
                        meta_description: meta_description,
                    });
                });

        })
        .catch(function (error) {
            res.render('site/products', {
                data: [],
                data2: [],
                cid: cid,
                scid: id,
                catname: catname,
                meta_keywords: meta_keywords,
                meta_description: meta_description
            });
        });




});

// Single products page
app.get('/product/:pid', function (req, res) {

    var { pid } = req.params;


    var data = '';
    var catname = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/singleproducts/' + pid,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            catname = response.data.data[0].subcatname;
            res.render('site/product', {
                data: response.data,
                cid: pid,
                catname: catname
            });
        })
        .catch(function (error) {
            res.render('site/product', {
                data: [],
                cid: pid,
                catname: catname
            });
        });

});

// Add to cart
app.post('/addcart', function (req, res) {

    const { product_id, quantity, unit_price, amount } = req.body;

    var data = JSON.stringify({
        "user_id": req.session.userid,
        "product_id": product_id,
        "quantity": quantity,
        "unit_price": unit_price,
        "amount": amount
    });

    //console.log(data);

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/cart',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            //req.session.error = 'Added successfully';
            res.status(201).json({ status: 'success', message: 'Added to Cart', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });



});

// Get cart
app.get('/getcart', function (req, res) {

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cart/' + req.session.userid,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.status(201).json({ status: 'success', message: 'Cart data', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });

});

// Get cat
app.get('/getcat', function (req, res) {

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/home/',
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.status(201).json({ status: 'success', message: 'Cart data', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });

});

// Update cart
app.post('/updatecart', function (req, res) {

    const { id, quantity, unit_price } = req.body;

    var data = JSON.stringify({
        "id": id,
        "quantity": quantity,
        "unit_price": unit_price
    });

    var config = {
        method: 'put',
        url: 'http://65.1.15.21:5000/api/cart',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Updated successfully';
            res.status(201).json({ status: 'success', message: 'Updated successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });




});

// Remove from cart
app.post('/removefromcart', function (req, res) {

    const { id } = req.body;

    var data = '';

    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/cart/' + id,
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });




});


// Clear cart
app.get('/clearcart', function (req, res) {

    var pid = req.session.userid;

    var data = JSON.stringify(
        {
            "user_id": pid
        }
    );

    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/cart',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Cleared successfully';
            res.redirect('/');
        })
        .catch(function (error) {
            console.log(error);
        });




});

// Cart page
app.get('/cart', function (req, res) {
    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cart/' + pid,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/cart', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/cart', {
                data: [],
            });
        });
});

// Checkout page
app.get('/checkout', function (req, res) {
    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cart/' + pid,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/checkout', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/checkout', {
                data: [],
            });
        });
});

// Orders page
app.get('/orders', function (req, res) {
    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/orders/' + pid,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/orders', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/orders', {
                data: [],
            });
        });
});

// Orders details page
app.get('/ordersdetails:id', function (req, res) {
    const { id } = req.params;

    var data = JSON.stringify({
        "id": id
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/orders',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/orderdetails', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/orderdetails', {
                data: [],
            });
        });
});

// Checkout page submit
app.post('/checkout', function (req, res) {

    const { amount, name, phone, address, state, pin } = req.body;

    console.log(amount);
    console.log(name);
    console.log(address);
    var d = new Date();
    var n = d.getTime();
    console.log(n);


    var data = JSON.stringify({
        "user_id": req.session.userid,
        "lat": "",
        "lng": "",
        "amount": amount,
        "txn": n,
        "name": name,
        "phone": phone,
        "address": address,
        "state": state,
        "pin": pin,
        "pay_mode": "Cash on Delivery",
        "promo": "0",
        "isnew": "0"
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/checkout',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            var sts = response.status;
            var dat = response.data;
            //console.log(dat.status);
            if (sts == 201) {

                var st = dat.status;
                if (st == 'success') {
                    req.session.error = 'Order placed successfully';
                    res.redirect('/');
                } else {
                    req.session.error = 'Some error occurred';
                    res.redirect('/checkout');
                }

            } else {
                req.session.error = 'Some error occurred';
                res.redirect('/checkout');
            }
        })
        .catch(function (error) {
            console.log(error);
        });

});

// Search page
app.post('/search', function (req, res) {

    var pid = req.body.s;
    console.log(pid);

    var data = JSON.stringify({
        "query": pid
    });
    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/search',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/search', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/search', {
                data: [],
            });
        });
});

// About page
app.get('/about', function (req, res) {

    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/2',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/about', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/about', {
                data: [],
            });
        });

});

// Contact page
app.get('/contact', function (req, res) {
    res.render('site/contact');
});

// Terms page
app.get('/terms', function (req, res) {
    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/1',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/terms', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/terms', {
                data: [],
            });
        });
});

// Blog page
app.get('/blog', function (req, res) {
    var data = '';
    var pid = req.session.userid;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/article',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/blog', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/blog', {
                data: [],
            });
        });
});

// Blog details page
app.get('/blog/:id', function (req, res) {

    var { id } = req.params;


    var data = '';
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/article/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('site/blogdetails', {
                data: response.data,
            });
        })
        .catch(function (error) {
            res.render('site/blogdetails', {
                data: [],
            });
        });

});

//Admin Pages
// login page 
app.get('/admin', function (req, res) {

    res.render('dashboard/login', {});
});


// login page submit
app.post('/admin', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/admin/' + req.body.email + '/' + req.body.password,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            var sts = response.status;
            var dat = response.data;
            //console.log(dat.status);
            if (sts == 201) {

                var st = dat.status;
                if (st == 'success') {
                    res.redirect('/admin/dashboard');
                } else {
                    res.render('dashboard/login', { error: dat.message });
                }

            } else {
                res.render('dashboard/login', { error: 'Some error occurred' });
            }
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Dashboard page
app.get('/admin/dashboard', function (req, res) {
    res.render('dashboard/dashboard', {
        pagetitle: 'dashboard'
    });
});

// Users
app.get('/admin/users', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/users',
        headers: {},
        data: data
    };
    
    axios(config)
        .then(function (response) {
            res.render('dashboard/users', {
                data: response.data,
                pagetitle: 'users'
            });
        })
        .catch(function (error) {
            res.render('dashboard/users', {
                data: [],
                pagetitle: 'users'
            });
        });


});

// view user profile 

app.get('/admin/profile:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/users_details/' + id+'/0', 
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {

            var data2 = '';
            console.log(id);
            var config2 = {
                method: 'get',
                url: 'http://65.1.15.21:5000/api/get_user_Post/' + id, 
                headers: {},
                data: data2
            };
        
            axios(config2)
                .then(function (response2) {
                    res.render('dashboard/profile', {
                        data: response.data,
                        data2: response2.data,
                        pagetitle: 'users'
                    });
                })
                .catch(function (error) {
                    res.render('dashboard/profile', {
                        data: [],
                        data2: [],
                        pagetitle: 'users'
                    });
                });
        })
        .catch(function (error) {
            res.render('dashboard/profile', {
                data: [],
                data2: [],
                pagetitle: 'users'
            });
        });
});

// post details page

app.get('/admin/post_details:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/getPostBy_postId/' + id, 
        headers: {},
        data: data
    };

            axios(config)
                .then(function (response) {
                    res.render('dashboard/post_details', {
                        data: response.data,
                        //pagetitle: 'users'
                    });
                })
                .catch(function (error) {
                    res.render('dashboard/post_details', {
                        data: [],
                       // pagetitle: 'users'
                    });
                });
        
        
});


// post report api

app.get('/admin/post_reports', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/getAll_reportPost',
        headers: {},
        data: data
    };
    
    axios(config)
        .then(function (response) {
            res.render('dashboard/post_reports', {
                data: response.data,
                pagetitle: 'report'
            });
        })
        .catch(function (error) {
            res.render('dashboard/post_reports', {
                data: [],
                pagetitle: 'report'
            });
        });


});

// All post list for admin

app.get('/admin/all_post_list', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/homePost/0',
        headers: {},
        data: data
    };
    
    axios(config)
        .then(function (response) {
            res.render('dashboard/all_post_list', {
                data: response.data,
                pagetitle: 'all_post'
            });
        })
        .catch(function (error) {
            res.render('dashboard/all_post_list', {
                data: [],
                pagetitle: 'all_post'
            });
        });

});

// Categories page
app.get('/admin/categories', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/categories',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/categories', {
                data: response.data,
                pagetitle: 'categories'
            });
        })
        .catch(function (error) {
            res.render('pages/categories', {
                data: [],
                pagetitle: 'categories'
            });
        });


});

// Add category page
app.get('/admin/add_category', function (req, res) {
    res.render('pages/add_category', {
        pagetitle: 'categories'
    });
});

// Add category submit
app.post('/admin/categories/add', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('title', fields.name);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);
        data.append('file', fs.createReadStream(files.image.path));

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/categories',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/categories');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit category page
app.get('/admin/edit_category:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/categories/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_category', {
                data: response.data,
                pagetitle: 'categories'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_category', {
                data: [],
                pagetitle: 'categories'
            });
        });
});

// Edit category submit
app.post('/admin/edit_category', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('title', fields.name);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/categories',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/categories');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete category
app.post('/admin/deletecategory', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/categories/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Sub categories page
app.get('/admin/sub_categories', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/sub-categories',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/sub_categories', {
                data: response.data,
                pagetitle: 'subcategories'
            });
        })
        .catch(function (error) {
            res.render('pages/sub_categories', {
                data: [],
                pagetitle: 'subcategories'
            });
        });


});

// Add sub category page
app.get('/admin/add_sub_category', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/categories',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_sub_category', {
                data: response.data,
                pagetitle: 'subcategories'
            });
        })
        .catch(function (error) {
            res.render('pages/add_sub_category', {
                data: [],
                pagetitle: 'subcategories'
            });
        });

});

// Add sub category submit
app.post('/admin/sub_categories/add', function (req, res) {


    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = JSON.stringify({ "title": fields.name, "cat_id": fields.cat_name });

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/sub-categories',
            headers: {
                'Content-Type': 'application/json'
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                console.log(response.data);
                res.redirect('/admin/sub_categories');
            })
            .catch(function (error) {
                console.log(error);
            });

    });




});

// Edit sub category page
app.get('/admin/edit_sub_category:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/sub-categoriesedit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_sub_category', {
                data: response.data,
                pagetitle: 'subcategories'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_sub_category', {
                data: [],
                pagetitle: 'subcategories'
            });
        });

});

// Edit sub category submit
app.post('/admin/edit_sub_category', function (req, res) {


    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = JSON.stringify({
            "id": fields.id,
            "title": fields.name,
            "cat_id": fields.cat_name
        });

        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/sub-categories',
            headers: {
                'Content-Type': 'application/json'
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                console.log(response.data);
                res.redirect('/admin/sub_categories');
            })
            .catch(function (error) {
                console.log(error);
            });

    });




});

// Delete sub category
app.post('/admin/deletesubcategory', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/sub-categories/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Prouducts page
app.get('/admin/products', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/products',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/products', {
                data: response.data,
                pagetitle: 'products'
            });
        })
        .catch(function (error) {
            res.render('pages/products', {
                data: [],
                pagetitle: 'products'
            });
        });


});

// Add product page
app.get('/admin/add_product', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/sub-categories',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_product', {
                data: response.data,
                pagetitle: 'products'
            });
        })
        .catch(function (error) {
            res.render('pages/add_product', {
                data: [],
                pagetitle: 'products'
            });
        });
});

// Add product submit
app.post('/admin/product/add', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('file', fs.createReadStream(files.image.path));
        data.append('sub_cat_id', fields.sub_cat_id);
        data.append('title', fields.title);
        data.append('mrp', fields.mrp);
        data.append('selling_price', fields.selling_price);
        data.append('size', fields.size);
        data.append('description', fields.description);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/products',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                res.redirect('/admin/products');
                //console.log(JSON.stringify(response.data));
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit products page
app.get('/admin/productsedit:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/productsedit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/productsedit', {
                data: response.data,
                pagetitle: 'products'
            });
        })
        .catch(function (error) {
            res.render('pages/productsedit', {
                data: [],
                pagetitle: 'products'
            });
        });

});

// Edit product submit
app.post('/admin/productsedit', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('sub_cat_id', fields.sub_cat_id);
        data.append('title', fields.title);
        data.append('mrp', fields.mrp);
        data.append('selling_price', fields.selling_price);
        data.append('size', fields.size);
        data.append('description', fields.description);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/products',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/products');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete product
app.post('/admin/deleteproduct', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/products/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Prouduct images page
app.get('/admin/productimages', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/singleproducts',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/productimages', {
                data: response.data,
                pagetitle: 'productimage'
            });
        })
        .catch(function (error) {
            res.render('pages/productimages', {
                data: [],
                pagetitle: 'productimage'
            });
        });


});

// Add product image page
app.get('/admin/add_product_image', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/products',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_product_image', {
                data: response.data,
                pagetitle: 'productimage'
            });
        })
        .catch(function (error) {
            res.render('pages/add_product_image', {
                data: [],
                pagetitle: 'productimage'
            });
        });
});

// Add product image submit
app.post('/admin/productimage/add', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('file', fs.createReadStream(files.image.path));
        data.append('product_id', fields.product_id);

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/singleproducts',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                res.redirect('/admin/productimages');
                //console.log(JSON.stringify(response.data));
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit products images page
app.get('/admin/productsimagesedit:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/singleproductsedit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/productsimagesedit', {
                data: response.data,
                pagetitle: 'productimage'
            });
        })
        .catch(function (error) {
            res.render('pages/productsimagesedit', {
                data: [],
                pagetitle: 'productimage'
            });
        });

});

// Edit product image submit
app.post('/admin/productsimagesedit', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('product_id', fields.product_id);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/singleproducts',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/productimages');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete product image
app.post('/admin/deleteproductimage', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/singleproducts/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Promo banners
app.get('/admin/promo', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/promo-banners',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/promo', {
                data: response.data,
                pagetitle: 'promobanner'
            });
        })
        .catch(function (error) {
            res.render('pages/promo', {
                data: [],
                pagetitle: 'promobanner'
            });
        });


});

// Add promo banner page
app.get('/admin/add_promo', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/categories',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_promo', {
                data: response.data,
                pagetitle: 'promobanner'
            });
        })
        .catch(function (error) {
            res.render('pages/add_promo', {
                data: [],
                pagetitle: 'promobanner'
            });
        });
});

// Add promo banner submit
app.post('/admin/add_promo', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('file', fs.createReadStream(files.image.path));
        data.append('cat_id', fields.cat_id);

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/promo-banners',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                res.redirect('/admin/promo');
                //console.log(JSON.stringify(response.data));
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});


// Edit promo banner page
app.get('/admin/promobanneredit:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/promobannersedit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/promobanneredit', {
                data: response.data,
                pagetitle: 'productimage'
            });
        })
        .catch(function (error) {
            res.render('pages/promobanneredit', {
                data: [],
                pagetitle: 'productimage'
            });
        });

});

// Edit promo banner submit
app.post('/admin/promobanneredit', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('cat_id', fields.cat_id);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/promo-banners',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/promo');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete promo image
app.post('/admin/deletepromobanner', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/promo-banners/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Offer banners
app.get('/admin/offer', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/offer-banners',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/offer', {
                data: response.data,
                pagetitle: 'offer'
            });
        })
        .catch(function (error) {
            res.render('pages/offer', {
                data: [],
                pagetitle: 'offer'
            });
        });


});

// Add offer banner page
app.get('/admin/add_offer', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/products',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_offer_banner', {
                data: response.data,
                pagetitle: 'offer'
            });
        })
        .catch(function (error) {
            res.render('pages/add_offer_banner', {
                data: [],
                pagetitle: 'offer'
            });
        });
});

// Add offer banner submit
app.post('/admin/add_offer', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('file', fs.createReadStream(files.file.path));
        data.append('product_id', fields.product_id);

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/offer-banners',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                res.redirect('/admin/offer');
                //console.log(JSON.stringify(response.data));
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit offer banner page
app.get('/admin/offerbannersedit:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/offerbanneredit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/offerbannersedit', {
                data: response.data,
                pagetitle: 'offer'
            });
        })
        .catch(function (error) {
            res.render('pages/offerbannersedit', {
                data: [],
                pagetitle: 'offer'
            });
        });

});

// Edit offer banner submit
app.post('/admin/offerbannersedit', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('product_id', fields.product_id);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/offer-banner',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/offer');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete offer banner
app.post('/admin/deleteofferbanner', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/offer-banners/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Adv banners
app.get('/admin/adv', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/adv-banners',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/adv', {
                data: response.data,
                pagetitle: 'adv'
            });
        })
        .catch(function (error) {
            res.render('pages/adv', {
                data: [],
                pagetitle: 'adv'
            });
        });


});

// Add adv banner page
app.get('/admin/add_adv', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/products',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/add_adv', {
                data: response.data,
                pagetitle: 'adv'
            });
        })
        .catch(function (error) {
            res.render('pages/add_adv', {
                data: [],
                pagetitle: 'adv'
            });
        });
});

// Add adv banner submit
app.post('/admin/add_adv', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('file', fs.createReadStream(files.file.path));
        data.append('product_id', fields.product_id);

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/adv-banners',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                res.redirect('/admin/adv');
                //console.log(JSON.stringify(response.data));
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit adv banner page
app.get('/admin/advbannersedit:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/advbanneredit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/advbannersedit', {
                data: response.data,
                pagetitle: 'adv'
            });
        })
        .catch(function (error) {
            res.render('pages/advbannersedit', {
                data: [],
                pagetitle: 'adv'
            });
        });

});

// Edit adv banner submit
app.post('/admin/advbannersedit', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('product_id', fields.product_id);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/adv-banner',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/adv');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete adv banner
app.post('/admin/deleteadvbanner', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/adv-banners/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Features
app.get('/admin/features', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/features',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/features', {
                data: response.data,
                pagetitle: 'features'
            });
        })
        .catch(function (error) {
            res.render('pages/features', {
                data: [],
                pagetitle: 'features'
            });
        });


});

// Add feature page
app.get('/admin/add_feature', function (req, res) {

    res.render('pages/add_feature', {
        pagetitle: 'features'
    });

});

// Add feature submit
app.post('/admin/add_feature', function (req, res) {


    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = JSON.stringify({ "title": fields.title, "text": fields.text });

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/features',
            headers: {
                'Content-Type': 'application/json'
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                console.log(response.data);
                res.redirect('/admin/features');
            })
            .catch(function (error) {
                console.log(error);
            });

    });




});

// Edit feature page
app.get('/admin/edit_feature:id', function (req, res) {
    const { id } = req.params;

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/featuresedit/' + id,
        headers: {}
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_feature', {
                data: response.data,
                pagetitle: 'features'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_feature', {
                data: [],
                pagetitle: 'features'
            });
        });

});

// Edit feature submit
app.post('/admin/edit_feature', function (req, res) {


    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = JSON.stringify({
            "id": fields.id,
            "title": fields.title,
            "text": fields.text
        });

        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/features',
            headers: {
                'Content-Type': 'application/json'
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                console.log(response.data);
                res.redirect('/admin/features');
            })
            .catch(function (error) {
                console.log(error);
            });

    });




});

// Delete feature
app.post('/admin/deletefeature', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/features/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Blog
app.get('/admin/blog', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/blog',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/blog', {
                data: response.data,
                pagetitle: 'blog'
            });
        })
        .catch(function (error) {
            res.render('pages/blog', {
                data: [],
                pagetitle: 'blog'
            });
        });


});

// Add blog page
app.get('/admin/add_blog', function (req, res) {
    res.render('pages/add_blog', {
        pagetitle: 'blog'
    });
});

// Add blog submit
app.post('/admin/add_blog', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('title', fields.title);
        data.append('insta_link', fields.insta_link);
        data.append('date', fields.date);
        data.append('file', fs.createReadStream(files.image.path));

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/blog',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/blog');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit blog page
app.get('/admin/edit_blog:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/blog/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_blog', {
                data: response.data,
                pagetitle: 'blog'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_blog', {
                data: [],
                pagetitle: 'blog'
            });
        });
});

// Edit blog submit
app.post('/admin/edit_blog', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('title', fields.title);
        data.append('insta_link', fields.insta_link);
        data.append('date', fields.date);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/blog',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/blog');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete blog
app.post('/admin/deleteblog', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/blog/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});


// Article
app.get('/admin/article', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/article',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/article', {
                data: response.data,
                pagetitle: 'article'
            });
        })
        .catch(function (error) {
            res.render('pages/article', {
                data: [],
                pagetitle: 'article'
            });
        });


});

// Add article page
app.get('/admin/add_article', function (req, res) {
    res.render('pages/add_article', {
        pagetitle: 'article'
    });
});

// Add article submit
app.post('/admin/add_article', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('title', fields.title);
        data.append('description', fields.description);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);
        data.append('file', fs.createReadStream(files.image.path));

        var config = {
            method: 'post',
            url: 'http://65.1.15.21:5000/api/article',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/article');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Edit article page
app.get('/admin/edit_article:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/article/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_article', {
                data: response.data,
                pagetitle: 'article'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_article', {
                data: [],
                pagetitle: 'article'
            });
        });
});

// Edit article submit
app.post('/admin/edit_article', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {
        //console.log(files.image.size);
        //console.log(fields);

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();
        data.append('id', fields.id);
        data.append('title', fields.title);
        data.append('description', fields.description);
        data.append('meta_keywords', fields.meta_keywords);
        data.append('meta_description', fields.meta_description);
        if (files.image.size > 0) {
            data.append('file', fs.createReadStream(files.image.path));
        }


        var config = {
            method: 'put',
            url: 'http://65.1.15.21:5000/api/article',
            headers: {
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then(function (response) {
                //console.log(response.data);
                res.redirect('/admin/article');
            })
            .catch(function (error) {
                //console.log(error);
            });

    });


});

// Delete article
app.post('/admin/deletearticle', function (req, res) {
    const { id } = req.body;
    var data = '';
    console.log(id);
    var config = {
        method: 'delete',
        url: 'http://65.1.15.21:5000/api/article/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            req.session.error = 'Deleted successfully';
            res.status(201).json({ status: 'success', message: 'Removed successfully', data: response.data })
        })
        .catch(function (error) {
            console.log(error);
        });


});

// Terms
app.get('/admin/terms', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/1',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/terms', {
                data: response.data,
                pagetitle: 'terms'
            });
        })
        .catch(function (error) {
            res.render('pages/terms', {
                data: [],
                pagetitle: 'terms'
            });
        });


});

// Edit terms page
app.get('/admin/edit_terms:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_terms', {
                data: response.data,
                pagetitle: 'terms'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_terms', {
                data: [],
                pagetitle: 'terms'
            });
        });
});

// Edit terms submit
app.post('/admin/edit_terms', function (req, res) {

    const { id, title, content } = req.body;
    var data = JSON.stringify(
        {
            "id": id,
            "title": title,
            "content": content
        }
    );

    var config = {
        method: 'put',
        url: 'http://65.1.15.21:5000/api/cms',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };
    axios(config)
        .then(function (response) {
            //console.log(response.data);
            res.redirect('/admin/terms');
        })
        .catch(function (error) {
            //console.log(error);
        });


});

// About
app.get('/admin/about', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/2',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/about', {
                data: response.data,
                pagetitle: 'about'
            });
        })
        .catch(function (error) {
            res.render('pages/about', {
                data: [],
                pagetitle: 'about'
            });
        });


});

// Edit about page
app.get('/admin/edit_about:id', function (req, res) {
    const { id } = req.params;
    var data = '';
    console.log(id);
    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/cms/' + id,
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/edit_about', {
                data: response.data,
                pagetitle: 'about'
            });
        })
        .catch(function (error) {
            res.render('pages/edit_about', {
                data: [],
                pagetitle: 'about'
            });
        });
});

// Edit about submit
app.post('/admin/edit_about', function (req, res) {

    const { id, title, content } = req.body;
    var data = JSON.stringify(
        {
            "id": id,
            "title": title,
            "content": content
        }
    );

    var config = {
        method: 'put',
        url: 'http://65.1.15.21:5000/api/cms',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };
    axios(config)
        .then(function (response) {
            //console.log(response.data);
            res.redirect('/admin/about');
        })
        .catch(function (error) {
            //console.log(error);
        });


});

// Orders
app.get('/admin/orders', function (req, res) {

    var data = '';

    var config = {
        method: 'get',
        url: 'http://65.1.15.21:5000/api/orders',
        headers: {},
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/orders', {
                data: response.data,
                pagetitle: 'orders'
            });
        })
        .catch(function (error) {
            res.render('pages/orders', {
                data: [],
                pagetitle: 'orders'
            });
        });


});

// Invoice
app.get('/admin/invoice:id', function (req, res) {

    const { id } = req.params;

    var data = JSON.stringify({
        "id": id
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/orders',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/invoice', {
                data: response.data,
                pagetitle: 'orders'
            });
        })
        .catch(function (error) {
            res.render('pages/invoice', {
                data: [],
                pagetitle: 'orders'
            });
        });


});

// App/ Website Invoice
app.get('/admin/orderinvoice:id', function (req, res) {

    const { id } = req.params;

    var data = JSON.stringify({
        "id": id
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/orders',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            res.render('pages/orderinvoice', {
                data: response.data,
                pagetitle: 'orders'
            });
        })
        .catch(function (error) {
            res.render('pages/orderinvoice', {
                data: [],
                pagetitle: 'orders'
            });
        });


});

// Print
app.get('/admin/print:id', function (req, res) {

    const { id } = req.params;

    var data = JSON.stringify({
        "id": id
    });

    var config = {
        method: 'post',
        url: 'http://65.1.15.21:5000/api/orders',
        headers: {
            'Content-Type': 'application/json'
        },
        data: data
    };

    axios(config)
        .then(function (response) {
            console.log(response.data);
            res.render('pages/print', {
                data: response.data,
                pagetitle: 'orders'
            });
        })
        .catch(function (error) {
            res.render('pages/print', {
                data: [],
                pagetitle: 'orders'
            });
        });


});

app.listen(8001);
console.log('8001 is the magic port');