var express = require('express');
var app = express();
const path = require('path');
const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
var cors = require('cors')

const pool = new pg.Pool({
    user: 'postgres',
    host: 'top.csgutkqhejo6.us-east-1.rds.amazonaws.com',
    database: 'postgres',
    password: 'Utcv$r729!3uIxM',
    port: 5432
});

const checkauth = require('./api/auth/jwt_auth');
const validation = require('./api/middleware/validation');

var bodyParser = require('body-parser');
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
var port = process.env.PORT || 5000;
//const app = express.Router();

pool.connect((err, client, release) => {
    if (err) {
        return console.error(
            'Error acquiring client', err.stack)
    }
    client.query('SELECT NOW()', (err, result) => {
        release()
        if (err) {
            return console.error(
                'Error executing query', err.stack)
        }
        console.log("Connected to Database !")
    })
})

app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});

app.use(function(req, res, next) {
    res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
  });


app.use(cors());


app.get('/health',cors(), function(req, res) {
    console.log("Health check API is Online123! 16-04-2022 age ") ;
    res.status(200).json({ message: 'Health check API is Online123! 19-04-2022 user image issue resolve' });
});

var usersAPI = require('./api/users');
app.post('/health/signup', cors(),  usersAPI.signup);
app.post('/health/Resend_OTP', cors(), usersAPI.Resend_OTP);
app.post('/health/verify_otp', cors(), usersAPI.verify_otp); 
app.post('/health/Reset_Password', cors(), usersAPI.Reset_Password);
app.post('/health/login', cors(), validation.login, usersAPI.login);
app.use('*', checkauth.checkauth);
app.post('/health/otp_verify', cors(), usersAPI.otp_verify);
app.post('/health/create_profile', cors(), validation.create_profile, usersAPI.create_profile);
app.post('/health/update_profile', cors(), validation.update_profile, usersAPI.update_profile);
app.post('/health/upload_user_image', cors(), usersAPI.upload_user_image);
app.post('/health/Set_location_radius', cors(), validation.Set_location_radius, usersAPI.Set_location_radius);
app.get('/health/sport_category', cors(), usersAPI.sport_category);
app.post('/health/sport_Sub_category_list', cors(), validation.sport_Sub_category_list, usersAPI.sport_Sub_category_list);
app.post('/health/Select_Sport_category', cors(), validation.Select_Sport_category, usersAPI.Select_Sport_category);
app.post('/health/Set_preferences', cors(), usersAPI.Set_preferences);
app.post('/health/Selected_Sport_category', cors(), validation.Selected_Sport_category, usersAPI.Selected_Sport_category);


 
app.listen(port);
console.log('Listening on port ' + port);